/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.oscilloscope;

import client.teavm.common.oscilloscope.Gauge;
import java.nio.ByteBuffer;
import java.util.function.Function;
import java.util.function.Supplier;
import libsidplay.common.SIDEmu;

public class FrequencyGauge
extends Gauge {
    private int voice;

    public FrequencyGauge(int width, int height, int voice, Function<String, String> localizer, Supplier<ByteBuffer> initGaugeBuffer) {
        super(width, height, initGaugeBuffer);
        this.voice = voice;
        this.text = localizer.apply("FREQUENCY");
    }

    public Gauge sample(SIDEmu sidemu) {
        int frqValue = (sidemu.readInternalRegister(1 + this.voice * 7) & 0xFF) << 8 | sidemu.readInternalRegister(0 + this.voice * 7) & 0xFF;
        float frq = 84.0f;
        if (frqValue != 0) {
            frq = (float)(Math.log((float)frqValue / 65535.0f) / Math.log(2.0) * 12.0);
        }
        this.accumulate(1.0f + frq / 84.0f);
        return this;
    }
}

